/* -LICENSE-START-
** Copyright (c) 2011 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/

#ifndef BMD_STREAMING_DECK_CONTROL_NOTIFIER_H__
#define BMD_STREAMING_DECK_CONTROL_NOTIFIER_H__

#import "DeckLinkAPI.h"
#import "COMObject.h"

@protocol BMDStreamingDeckControlDelegate
- (void)timecodeUpdate:(BMDTimecodeBCD)currentTimecode;
- (void)vtrControlStateChanged:(BMDDeckControlVTRControlState)newState error:(BMDDeckControlError)error;
- (void)deckControlEventReceived:(BMDDeckControlEvent)event error:(BMDDeckControlError)error;
- (void)deckControlStatusChanged:(BMDDeckControlStatusFlags)flags mask:(uint32_t)mask;
@end

extern const REFIID kIID_IDeckLinkDeckControlStatusCallback;

class BMDStreamingDeckControlNotifier : public COMObject<IDeckLinkDeckControlStatusCallback,
                                                   &kIID_IDeckLinkDeckControlStatusCallback>
{
public:
					BMDStreamingDeckControlNotifier(id<BMDStreamingDeckControlDelegate> delegate) : mDelegate(delegate) {}

    virtual SInt32	TimecodeUpdate(BMDTimecodeBCD currentTimecode);
    virtual SInt32	VTRControlStateChanged(BMDDeckControlVTRControlState newState, BMDDeckControlError error);
    virtual SInt32	DeckControlEventReceived(BMDDeckControlEvent event, BMDDeckControlError error);
    virtual SInt32	DeckControlStatusChanged(BMDDeckControlStatusFlags flags, uint32_t mask);

private:
	virtual			~BMDStreamingDeckControlNotifier() {}

	id<BMDStreamingDeckControlDelegate> mDelegate;
};

#endif	// BMD_STREAMING_DECK_CONTROL_NOTIFIER_H__
